<?php

declare(strict_types=1);

namespace Drupal\Tests\canvas_extjs\FunctionalJavascript;

use Drupal\FunctionalJavascriptTests\WebDriverTestBase;

/**
 * Tests JavaScript rendering variant in browser.
 *
 * @group canvas_extjs
 */
class JavaScriptRenderingBrowserTest extends WebDriverTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'canvas',
    'canvas_extjs',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Copy test fixtures to public files for serving.
    $fileSystem = \Drupal::service('file_system');
    $modulePath = \Drupal::service('extension.list.module')->getPath('canvas_extjs');
    $publicPath = DRUPAL_ROOT . '/sites/default/files';

    $fileSystem->copy(
      DRUPAL_ROOT . '/' . $modulePath . '/tests/fixtures/test-components.js',
      $publicPath . '/test-components.js',
      TRUE
    );

    $fileSystem->copy(
      DRUPAL_ROOT . '/' . $modulePath . '/tests/fixtures/test-extjs-rendering.html',
      $publicPath . '/test-extjs-rendering.html',
      TRUE
    );

    $fileSystem->copy(
      DRUPAL_ROOT . '/' . $modulePath . '/js/component-loader.js',
      $publicPath . '/component-loader.js',
      TRUE
    );
  }

  /**
   * Test JavaScript rendering with recursion.
   */
  public function testJavascriptRendering(): void {
    // Navigate to test page.
    $this->drupalGet('/sites/default/files/test-extjs-rendering.html');

    // Check if JavaScript executed by looking for once data attribute.
    $hasExecuted = $this->getSession()->wait(10000, "document.querySelector('[data-once-extjs-component]') !== null");

    if (!$hasExecuted) {
      $this->markTestSkipped('ES modules do not execute in this test environment');
    }

    // Wait for components to render.
    $this->assertSession()->waitForElement('css', '.test-button', 10000);

    // Verify simple buttons rendered.
    $button1 = $this->getSession()->getPage()->find('css', '#test-button-1 .test-button');
    $this->assertNotNull($button1, 'Test button 1 should exist');
    $this->assertEquals('Click Me', $button1->getText());

    $button2 = $this->getSession()->getPage()->find('css', '#test-button-2 .test-button');
    $this->assertNotNull($button2, 'Test button 2 should exist');
    $this->assertEquals('Secondary Button', $button2->getText());

    // Verify layout with nested button.
    $layout = $this->getSession()->getPage()->find('css', '.two-column-layout');
    $this->assertNotNull($layout, 'Layout should exist');

    $nestedButton = $layout->find('css', '.column-one .test-button');
    $this->assertNotNull($nestedButton, 'Nested button should exist');
    $this->assertEquals('Nested Button', $nestedButton->getText());

    // Verify error handling.
    $errorDiv = $this->getSession()->getPage()->find('css', '#unknown-1.error');
    $this->assertNotNull($errorDiv, 'Error div should exist');
    $this->assertStringContainsString('not found', $errorDiv->getText());
  }

}
