# CAPTCHA Protected Page

This module provides flexible CAPTCHA protection 
for any page on your Drupal site.

---

## Table of Contents
1. [Features](#features)
2. [Installation](#installation)
3. [Configuration](#configuration)
4. [Maintainers](#maintainers)

---

## Features
- Protect any path with CAPTCHA (supports wildcards)
- Role-specific verification requirements
- Configurable session duration (1 min to 1 year)
- Works with data export pages and long-running processes

---

## Installation
1. Download the module:
   - composer require drupal/captcha_protected_page
2. Enable the module:
   - drush en captcha_protected_page

---

## Configuration

1. Navigate to: 
   - /admin/config/system/captcha-protected-page
2. Protected Paths:
   - Specify the path of the page that requires CAPTCHA verification
3. Cookie Expiration:
   - Set verification duration (default: 24 hours)
4. Role Restrictions:
   - Applies to anonymous users by default
   - Optional: Require verification for specific roles

---

## Maintainers
  Carlo Miguel Agno (carlagno) - https://www.drupal.org/user/3317429
