/**
 * @file
 * Contains the definition of the behaviour captchafox.
 */

(function ($, Drupal) {
  'use strict';
  Drupal.behaviors.captchafox = {
    attach: function (context) {
      $('.captchafox', context).each(function () {
        if (
          typeof captchafox === 'undefined' ||
          typeof captchafox.render !== 'function'
        ) {
          return;
        }
        if ($(this).closest('body').length > 0) {
          if ($(this).hasClass('captchafox-processed')) {
            captchafox.reset();
          }
          else {
            captchafox.render(this, $(this).data());
            $(this).addClass('captchafox-processed');
          }
        }
      });
    }
  };

  window.drupalCaptchafoxOnload = function () {
    $('.captchafox').each(function () {
      if (!$(this).hasClass('captchafox-processed')) {
        captchafox.render(this, $(this).data());
        $(this).addClass('captchafox-processed');
      }
    });
  };
})(jQuery, Drupal);
