<?php

namespace Drupal\captchafox\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure CaptchaFox settings for this site.
 */
class CaptchaFoxAdminSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'captchafox_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('captchafox.settings');

    $form['general'] = [
      '#type' => 'details',
      '#title' => $this->t('General settings'),
      '#open' => TRUE,
    ];

    $form['general']['captchafox_site_key'] = [
      '#default_value' => $config->get('site_key'),
      '#description' => $this->t(
        'The site key given to you when you <a href=":url" target="_blank">register for CaptchaFox</a>.',
        [':url' => 'https://portal.captchafox.com']
      ),
      '#maxlength' => 40,
      '#required' => TRUE,
      '#title' => $this->t('Site key'),
      '#type' => 'textfield',
    ];

    $form['general']['captchafox_secret_key'] = [
      '#default_value' => $config->get('secret_key'),
      '#description' => $this->t(
        'The secret key given to you when you <a href=":url" target="_blank">register for CaptchaFox</a>.',
        [':url' => 'https://portal.captchafox.com']
      ),
      '#maxlength' => 40,
      '#required' => TRUE,
      '#title' => $this->t('Secret key'),
      '#type' => 'textfield',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $config = $this->config('captchafox.settings');
    $config
      ->set('site_key', $form_state->getValue('captchafox_site_key'))
      ->set('secret_key', $form_state->getValue('captchafox_secret_key'))
      ->save();

    parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['captchafox.settings'];
  }

}
