<?php

namespace Drupal\captchafox\CaptchaFox;

use GuzzleHttp\ClientInterface;

/**
 * Sends POST requests to the Turnstile service.
 */
class Drupal8Post implements RequestMethodInterface {

  /**
   * Guzzle\Client instance.
   *
   * @var \GuzzleHttp\ClientInterface
   */
  protected $httpClient;

  /**
   * {@inheritdoc}
   */
  public function __construct(ClientInterface $http_client) {
    $this->httpClient = $http_client;
  }

  /**
   * Submit the POST request with the specified parameters.
   *
   * @param string $url
   *   Request URL.
   * @param array $params
   *   Request parameters.
   *
   * @return object
   *   Body of the Turnstile response.
   *
   * @throws \GuzzleHttp\Exception\GuzzleException
   */
  public function submit(string $url, array $params): object {
    $options = [
      'headers' => [
        'Content-type' => 'application/x-www-form-urlencoded',
      ],
      'body' => http_build_query($params, '', '&'),
      // Stop firing exception on response status code >= 300.
      // See http://docs.guzzlephp.org/en/stable/handlers-and-middleware.html
      'http_errors' => FALSE,
    ];
    $response = $this->httpClient->post($url, $options);

    if ($response->getStatusCode() == 200) {
      // The service request was successful.
      $result = (string) $response->getBody();
    }
    elseif ($response->getStatusCode() < 0) {
      // Negative status codes typically point to network or socket issues.
      $result = '{"success": false, "error-codes": ["connection-failed"]}';
    }
    else {
      // Positive none 200 status code typically means the request has failed.
      $result = '{"success": false, "error-codes": ["bad-response"]}';
    }

    return json_decode($result);
  }

}
