<?php

namespace Drupal\cas_user_ban_vbo\Plugin\Action;

use Drupal\cas\Service\CasUserManager;
use Drupal\cas_user_ban\CasUserBanManagerInterface;
use Drupal\cas_user_ban\Traits\UserCancelFormsTrait;
use Drupal\Core\Action\Attribute\Action;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Plugin\PluginFormInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\views_bulk_operations\Plugin\Action\CancelUserAction as VboCancelUserAction;
use Psr\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Cancel a user account.
 */
#[Action(
  id: 'cas_user_ban_vbo_cancel_user_action',
  label: new TranslatableMarkup('Cancel the selected user accounts'),
  type: 'user'
)]
class CancelUserAction extends VboCancelUserAction implements ContainerFactoryPluginInterface, PluginFormInterface {

  use UserCancelFormsTrait;

  /**
   * The event dispatcher service.
   *
   * @var \Psr\EventDispatcher\EventDispatcherInterface
   */
  protected EventDispatcherInterface $eventDispatcher;

  /**
   * The CAS user ban manager service.
   *
   * @var \Drupal\cas_user_ban\CasUserBanManagerInterface
   */
  protected CasUserBanManagerInterface $casUserBanManager;

  /**
   * The CAS user manager service.
   *
   * @var \Drupal\cas\Service\CasUserManager
   */
  protected CasUserManager $casUserManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = parent::create(
      $container,
      $configuration,
      $plugin_id,
      $plugin_definition,
    );

    $instance->messenger = $container->get('messenger');
    $instance->eventDispatcher = $container->get(EventDispatcherInterface::class);
    $instance->casUserBanManager = $container->get(CasUserBanManagerInterface::class);
    $instance->casUserManager = $container->get(CasUserManager::class);

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);

    $bulk_keys = $this->context['list'];
    $uids = array_column($bulk_keys, '0');

    $this->addBanField($form, $form_state, $uids);

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function execute($account = NULL): void {
    parent::execute($account);
    $to_be_banned = $this->configuration['ban_cas_usernames'] ?? FALSE;
    $cas_username = $this->casUserManager->getCasUsernameForAccount($account->id());

    // Conditions to match in order to ban the user:
    // - Configuration is marked to be banned.
    // - User has a CAS username.
    // - User is not the current user.
    if (
      $to_be_banned &&
      $cas_username !== FALSE &&
      $this->currentUser->getAccount()->id() !== $account->id()
    ) {
      $this->banUser($cas_username);
    }
  }

}
