<?php

declare(strict_types=1);

namespace Drupal\cas_user_ban;

/**
 * Provides an interface for user managers.
 */
interface CasUserBanManagerInterface {

  /**
   * Adds a username to the ban list.
   *
   * @param string $username
   *   The username to ban.
   *
   * @throws \Drupal\cas_user_ban\Exception\InvalidCasUsernameException
   * @throws \Drupal\cas_user_ban\Exception\ExistingBanException
   */
  public function add(string $username): void;

  /**
   * Checks if a username is banned.
   *
   * @param string $username
   *   The username to check.
   *
   * @return bool
   *   If the ban exists.
   */
  public function isBanned(string $username): bool;

  /**
   * Removes a username to the ban list.
   *
   * @param string $username
   *   The username to remove.
   *
   * @throws \Drupal\cas_user_ban\Exception\BanNotFoundException
   */
  public function remove(string $username): void;

}
