<?php

declare(strict_types=1);

namespace Drupal\cas_user_ban_test\EventSubscriber;

use Drupal\cas_user_ban\Event\FilterUserCancelMethodEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Test event subscriber for FilterUserCancelMethodEvent.
 */
final class FilterUserCancelMethodSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      FilterUserCancelMethodEvent::NAME => 'onFilter',
    ];
  }

  /**
   * Subscribe to the filter on user cancel method.
   *
   * @param \Drupal\cas_user_ban\Event\FilterUserCancelMethodEvent $event
   *   The event subscribed.
   */
  public function onFilter(FilterUserCancelMethodEvent &$event): void {
    // Add new method and keep one with access restricted on form.
    $event->setAllowedMethods([
      'user_cancel_reassign',
      'test_cancel_method',
    ]);
  }

}
