<?php

declare(strict_types=1);

namespace Drupal\cas_user_ban_test\Hook;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Class for testing user cancel form methods access.
 */
final class UserCancelHooks {

  use StringTranslationTrait;

  /**
   * Implements hook_form_FORM_ID_alter().
   *
   * @see \Drupal\user\Form\UserCancelForm
   */
  #[Hook('form_user_cancel_form_alter')]
  public function alter(array &$form, FormStateInterface $form_state): void {
    $form['user_cancel_method']['user_cancel_reassign']['#access'] = FALSE;
  }

  /**
   * Implements hook_form_FORM_ID_alter().
   *
   * @see \Drupal\user\Form\UserMultipleCancelConfirm
   */
  #[Hook('form_user_multiple_cancel_confirm_alter')]
  public function alterMultiple(array &$form, FormStateInterface $form_state): void {
    $form['user_cancel_method']['user_cancel_reassign']['#access'] = FALSE;
  }

  /**
   * Implements hook_form_FORM_ID_alter().
   *
   * @see \Drupal\views_bulk_operations\Form\ConfigureAction
   */
  #[Hook('form_views_bulk_operations_configure_action_alter')]
  public function alterConfigure(array &$form, FormStateInterface $form_state): void {
    if (isset($form['user_cancel_method'])) {
      $form['user_cancel_method']['user_cancel_reassign']['#access'] = FALSE;
    }
  }

  /**
   * Implements hook_user_cancel_methods_alter().
   */
  #[Hook('user_cancel_methods_alter')]
  public function cancelMethods(array &$methods): void {
    $methods['test_cancel_method'] = [
      'title' => $this->t('Test cancel method.'),
      'description' => $this->t('A test cancel method to verify possibility of adding custom methods.'),
    ];
  }

}
