<?php

declare(strict_types=1);

namespace Drupal\Tests\cas_user_ban\Traits;

/**
 * Provides helper functions to assert banned users.
 */
trait BannedUsersTrait {

  /**
   * Retrieves the banned users.
   *
   * @return array
   *   The banned users.
   */
  protected function getBannedUsers(): array {
    $list = \Drupal::database()->select('cas_user_ban', 'b')
      ->fields('b')
      ->orderBy('timestamp', 'DESC')
      ->execute()
      ->fetchAll(\PDO::FETCH_ASSOC);

    return $list;
  }

  /**
   * Assert function to verify the users in the banned users list.
   *
   * @param array $expected_banned_users
   *   The users to be expected.
   */
  protected function assertBannedUsers(array $expected_banned_users): void {
    $this->assertEquals($expected_banned_users, $this->getBannedUsers());
  }

  /**
   * Assert function to verify the usernames in the banned users list.
   *
   * @param array $expected_banned_usernames
   *   The usernames to be expected.
   */
  protected function assertBannedUsernames(array $expected_banned_usernames): void {
    $this->assertEquals(
      $expected_banned_usernames,
      array_column($this->getBannedUsers(), 'cas_username')
    );
  }

}
