# CAS User Ban

The CAS User Ban module prevents the creation of users based on their CAS
username.

**Note:** The module does not prevent user login for existing users with a
related banned CAS username.

## Requirements

This module requires the following other modules:

- [CAS](https://www.drupal.org/project/cas)

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Usage

When deleting a user account that is managed by the CAS module, the module
provides an option to add the CAS username to a list of banned names.

The module then prevents the creation of any user with a CAS username that is in
the banned users list.

The list of banned CAS usernames can be managed at `/admin/people/cas/banned-users-list`.

The sub-module cas_user_ban_vbo adds support for the views_bulk_operation module.
Please note that a dedicated action is created (`cas_user_ban_vbo_cancel_user_action`),
which should be used over the module one.

## API

### Custom implementations of user cancel forms

This module provides a trait to help with the implementation of the ban
functionality in custom user cancel forms: `Drupal\cas_user_ban\Traits\UserCancelFormsTrait`.\
This is particularly useful if you have already a custom user cancel form or action,
and you want to add support for banning user accounts.

To add the functionality, import the trait above in your form class and invoke
the `addBanField()` method.

Example:

```php
// We need to pass current form, form state, UIDs for the users to be banned and
// submit element where to place the ban submit handler.
$uids = ['5', '6', '8'];
$this->addBanField($form, $form_state, $uids, $form['actions']['submit']['#submit'])
```

The trait also handles the submission process to apply the ban based on the
selected cancellation method.

Please note that the methods support forms in line with core UserCancelForm,
where the IDs of the users being deleted are already decided on form build phase.

### Events

All the events that this module dispatches are located in the `src/Event`

#### FilterUserCancelMethodEvent

This event is intended to allow altering the allowed cancel methods in the
different user cancel forms.

The event is dispatched for every form that uses UserCancelFormsTrait to build
the ban field.

## Contributing

[DDEV](https://ddev.com), a Docker-based PHP development tool for a streamlined
and unified development process, is the recommended tool for contributing to the
module. The [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib)
addon makes it easy to develop a Drupal module by offering the tools to set up
and test the module.

### Development configuration

Inside the cloned project run:

```sh
# Fire up the Docker containers.
ddev start
# Install the PHP dependencies.
ddev poser
# Symlink the module inside "web/modules/custom".
ddev symlink-project
# Install Drupal and enable the module.
ddev install
# Run this if you want to use the eslint command.
ddev exec "cd web/core && yarn install"
```

### Changing the Drupal core version

* Create a file `.ddev/config.local.yaml`
* Set the desired Drupal core version. E.g.,
  ```yaml
  web_environment:
    - DRUPAL_CORE=^10.3
  ```
* Run `ddev restart`

### Run tests

```sh
# Run PHPUnit tests.
ddev phpunit
# Run PHP coding standards checks.
ddev phpcs
# Fix coding standards findings.
ddev phpcbf
# Run PHP static analysis.
ddev phpstan
# Run ESLint on Javascript and YAML files.
ddev eslint
```
