<?php

declare(strict_types=1);

namespace Drupal\cas_user_ban\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Event to change the allowed methods on user cancel form to ban a user.
 */
class FilterUserCancelMethodEvent extends Event {

  /**
   * The event name.
   *
   * @var string
   */
  const NAME = 'cas_user_ban.filter_user_cancel_method';

  public function __construct(
    protected array $allowedMethods,
  ) {}

  /**
   * Getter for $allowedMethods.
   *
   * @return array
   *   The allowed methods.
   */
  public function getAllowedMethods(): array {
    return $this->allowedMethods;
  }

  /**
   * Setter for $allowedMethods.
   *
   * @param array $allowedMethods
   *   The validation path to be used.
   */
  public function setAllowedMethods(array $allowedMethods): void {
    $this->allowedMethods = $allowedMethods;
  }

}
