<?php

declare(strict_types=1);

namespace Drupal\cas_user_ban\Hook;

use Drupal\cas\Service\CasUserManager;
use Drupal\cas_user_ban\CasUserBanManagerInterface;
use Drupal\cas_user_ban\Traits\UserCancelFormsTrait;
use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\Render\Element;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\Core\StringTranslation\TranslationInterface;
use Psr\EventDispatcher\EventDispatcherInterface;

/**
 * Class for user cancel forms hooks.
 */
final class UserCancelFormsHooks {

  use UserCancelFormsTrait;
  use DependencySerializationTrait;

  public function __construct(
    protected EventDispatcherInterface $eventDispatcher,
    protected CasUserBanManagerInterface $casUserBanManager,
    protected CasUserManager $casUserManager,
    protected AccountProxyInterface $currentUser,
    protected MessengerInterface $messenger,
    TranslationInterface $string_translation,
  ) {
    $this->setStringTranslation($string_translation);
  }

  /**
   * Implements hook_form_FORM_ID_alter().
   *
   * @see \Drupal\user\Form\UserCancelForm
   */
  #[Hook('form_user_cancel_form_alter')]
  public function alter(array &$form, FormStateInterface $form_state): void {
    $uid = (int) $form['uid']['#value'];

    $this->addBanField($form, $form_state, [$uid], $form['actions']['submit']['#submit']);
    $form['ban_cas_usernames']['#title'] = $this->t('Prevent user from re-creating the account.');
  }

  /**
   * Implements hook_form_FORM_ID_alter().
   *
   * @see \Drupal\user\Form\UserMultipleCancelConfirm
   */
  #[Hook('form_user_multiple_cancel_confirm_alter')]
  public function multipleAlter(array &$form, FormStateInterface $form_state): void {
    $uids = Element::children($form['accounts']);

    $this->addBanField($form, $form_state, $uids, $form['#submit']);
  }

}
