<?php

declare(strict_types=1);

namespace Drupal\Tests\cas_user_ban\Functional;

use Drupal\cas_user_ban\CasUserBanManagerInterface;
use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\cas\Traits\CasTestTrait;
use Drupal\Tests\cas_user_ban\Traits\BannedUsersTrait;

/**
 * Tests banning users.
 *
 * @group cas_user_ban
 */
class BanUsersFormTest extends BrowserTestBase {

  use CasTestTrait;
  use BannedUsersTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'block',
    'cas_user_ban',
    'cas_mock_server',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Tests ban users form.
   */
  public function testBanUsers() {
    $this->drupalPlaceBlock('local_actions_block');
    $assert_session = $this->assertSession();

    // Prepare different users to trigger all messages types.
    $this->createCasUser(
      'brucewayne',
      'brucewayne@waynecorporation.com',
      'ImBatman',
    );
    $cas_user_manager = \Drupal::service('cas.user_manager');
    $cas_user_manager->register('brucewayne', 'brucewayne', []);

    $cas_user_ban_manager = \Drupal::service(CasUserBanManagerInterface::class);
    $cas_user_ban_manager->add('damianwayne');

    // User without permission can't access the form.
    $this->drupalGet('/admin/people/cas/ban_users');
    $assert_session->statusCodeEquals(403);

    $this->drupalLogin($this->drupalCreateUser(['administer users']));

    // Check that link to the form is present in the banned users list page.
    $this->drupalGet('/admin/people/cas/banned-users-list');
    $this->clickLink('Ban users');
    $assert_session->addressEquals('/admin/people/cas/ban_users');
    $assert_session->pageTextContains('CAS ban users');
    $assert_session->pageTextContains('Use this form to ban one or more CAS usernames, preventing them to create an account.');

    // Check that the field is required.
    $this->submitForm([], 'Ban users');
    $assert_session->statusMessageContains('CAS username(s) field is required.', 'error');

    // Check that usernames are banned after submitting the form.
    $this->submitForm([
      'cas_usernames' => " damianwayne  \n \n \n\n brucewayne \n acethebathound",
    ], 'Ban users');
    $this->assertBannedUsernames(['acethebathound', 'brucewayne', 'damianwayne']);
    $assert_session->statusMessageContains('The following CAS usernames were banned: acethebathound.', 'status');
    $assert_session->statusMessageContains('The following CAS usernames are already banned: damianwayne.', 'warning');
    $assert_session->statusMessageContains('The following CAS usernames were banned but an account is linked to them: brucewayne.', 'warning');
  }

}
