<?php

declare(strict_types=1);

namespace Drupal\Tests\cas_user_ban\FunctionalJavascript;

use Drupal\cas_user_ban\CasUserBanManagerInterface;
use Drupal\Core\Url;
use Drupal\FunctionalJavascriptTests\WebDriverTestBase;
use Drupal\Tests\cas_user_ban\Traits\BannedUsersTrait;

/**
 * Tests the remove ban confirmation form dialog in banned users list.
 *
 * @group cas_user_ban
 */
class RemoveBanFormDialogTest extends WebDriverTestBase {

  use BannedUsersTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'cas_user_ban',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Tests the dialog displayed when clicking delete button.
   */
  public function testRemoveBanFormDialog(): void {
    $cas_user_ban_manager = \Drupal::service(CasUserBanManagerInterface::class);
    $cas_user_ban_manager->add('the_penguin');
    $assert_session = $this->assertSession();

    $this->drupalLogin($this->createUser(['administer users']));
    $this->drupalGet('/admin/people/cas/banned-users-list');

    // Test that a dialog is open when clicking the delete button.
    $this->clickLink('Delete');
    $dialog = $assert_session->waitForElement('css', '.ui-dialog');
    $button_pane = $assert_session->elementExists('css', '.ui-dialog-buttonpane', $dialog);
    $this->assertEquals(
      'Are you sure you want to unblock CAS username the_penguin?',
      $assert_session->elementExists('css', '.ui-dialog-title', $dialog)->getText(),
    );
    $this->assertEquals(
      'This action cannot be undone.',
      $assert_session->elementExists('css', '.ui-dialog-content', $dialog)->getText(),
    );

    // Test that closing the dialog with cancel button or X button won't remove
    // the ban.
    $dialog->find('css', 'button.ui-dialog-titlebar-close')->press();
    $assert_session->elementNotExists('css', '.ui-dialog');
    $assert_session->statusMessageNotExists();
    $this->assertBannedUsernames(['the_penguin']);

    $this->clickLink('Delete');
    $dialog = $assert_session->waitForElement('css', '.ui-dialog');
    $assert_session->buttonExists('Cancel', $button_pane)->press();
    $assert_session->elementNotExists('css', '.ui-dialog');
    $assert_session->statusMessageNotExists();
    $this->assertBannedUsernames(['the_penguin']);

    // Test that confirming the removal will trigger the unban.
    $this->clickLink('Delete');
    $dialog = $assert_session->waitForElement('css', '.ui-dialog');
    $assert_session->buttonExists('Confirm', $button_pane)->press();
    $assert_session->addressEquals(Url::fromRoute('cas_user_ban.banned_users_list'));
    $assert_session->statusMessageContains('The ban for the CAS username the_penguin has been deleted.', 'status');
    $this->assertBannedUsernames([]);
  }

}
