<?php

declare(strict_types=1);

namespace Drupal\Tests\cas_user_ban\Traits;

use Behat\Mink\Element\NodeElement;

/**
 * Provides helper functions to assert radio options in forms.
 */
trait RadioOptionsTrait {

  /**
   * Asserts that a radios element contains only the expected radio inputs.
   *
   * @param \Behat\Mink\Element\NodeElement $fieldset
   *   The fieldset that represents the Drupal "radios" element.
   * @param list<string> $expected
   *   Either the label, ID or name of each of the expected radio inputs.
   */
  protected function assertRadioOptions(NodeElement $fieldset, array $expected): void {
    $this->assertSameSize($expected, $fieldset->findAll('css', 'input'));
    // We cannot collect all the existing inputs correctly, as named radio
    // selector matches also on ID or name.
    foreach ($expected as $label) {
      $this->assertSession()->elementExists('named', ['radio', $label], $fieldset);
    }
  }

}
