const { defineAsyncComponent, markRaw } = Vue;
const globalMixin = {
  methods: {
    hasPermission(key) {
      return drupalSettings.user_permissions.includes(key);
    },
    actionMessages(event, message) {
      const containerOptions = event.target.closest('.castorcito--more-options');
      const containerMessage = event.target.closest('.castorcito--more-operations').querySelector('.message');
      containerMessage.classList.add('show');
      containerOptions.classList.add('visually-hidden');
      containerMessage.textContent = message;
      setTimeout(() => {
        containerMessage.classList.remove('show');
        containerMessage.textContent = '';
      }, 2000);
    },
    triggerAddAnotherComponent(field_name_class, delta = null) {
      const selector = `input[target_field_name="add-another-item-${field_name_class}"]`;
      const addAnotherBoton = document.querySelector(selector);
      const eventoMousedown = new MouseEvent('mousedown', {
        bubbles: true,
        cancelable: true,
        view: window
      });

      if (delta !== null) {
        document.addEventListener('focusin', (event) => {
          if (event.target.tagName === 'TEXTAREA') {
            if (event.target.closest(`[data-drupal-selector="edit-${field_name_class}"]`)) {
              this.setFocusComponent(field_name_class, delta);
            }
          }
        });
      }
      addAnotherBoton.dispatchEvent(eventoMousedown);
    },
    setFocusComponent(field_name_class, delta) {
      this.$nextTick(() => {
        const duplicateElement = document.querySelector(`.field--name-${field_name_class} [data-castorcito-delta="${delta + 1}"]`);
        duplicateElement.querySelector('.claro-details__summary').focus();
        duplicateElement.querySelector('.claro-details__summary').scrollIntoView({ behavior: 'smooth', block: 'center' });
      });
    },
    toggleOperations(event) {
      const containerOperations = event.target.closest('.castorcito--more-operations');
      const containerOptions = containerOperations.querySelector('.castorcito--more-options');
      if (containerOptions) {
        containerOptions.classList.contains('visually-hidden') ? containerOptions.classList.remove('visually-hidden') : containerOptions.classList.add('visually-hidden');
      }
    },
    duplicateFocus(event, delta) {
      this.$nextTick(() => {
        const duplicateItemElement = event.target.closest('.castorcito-field-container').querySelector(`[data-castorcito-container-delta="${delta + 1}"]`);
        duplicateItemElement.querySelector('.claro-details__summary').focus();
        duplicateItemElement.querySelector('.claro-details__summary').scrollIntoView({ behavior: 'smooth', block: 'center' });
      });
    },
    addDragStyle(event) {
      const dragElement = event.target;
      dragElement.closest('.fieldset__wrapper').querySelectorAll('.castorcito--drag').forEach((item, index) => {
        item.classList.remove('drag-previous');
      });
      dragElement.closest('.castorcito--drag').classList.add('drag-previous');
      dragElement.closest('.castorcito--drag').querySelector('.claro-details__summary').focus();
    },
    loadedCFieldComponent(type) {
      const cfieldJsPath = drupalSettings.castorcito_plugins_settings[type].cfield_js_path;
      const asyncComponent = defineAsyncComponent(() =>
        import(drupalSettings.path.baseUrl + cfieldJsPath)
      );

      return  markRaw(asyncComponent);
    }
  }
};

export default globalMixin;
