export default {
  props: ['fieldModel', 'componentFieldSettings', 'fieldName'],
  data() {
    return {
      isRequired: this.componentFieldSettings.required
    };
  },
  template: `
    <div class="form-item form-type--checkbox form-type--boolean">
      <input
        type="checkbox"
        :id="fieldName"
        :name="fieldName"
        v-model="fieldModel.value"
        :true-value="1"
        :false-value="0"
        class="form-checkbox form-boolean form-boolean--type-checkbox"
        :class="{'required': isRequired }"
        :required="isRequired"
      >
      <label :for="fieldName" class="form-item__label option" :class="{'form-required': isRequired }">{{ componentFieldSettings.label }}</label>
      <div class="form-item__description">{{ componentFieldSettings.description }}</div>
    </div>
  `
};
