(function ($) {
  Drupal.behaviors.basepack_accordion = {
    attach: function(context, settings) {
      $('.basepack-accordion-item--title-container').unbind('click');
      $('.basepack-accordion-item--title-container').click(function () {
        $(this).addClass('is-active');

        if (!(false == $(this).next().is(':visible'))) {
          $(this).removeClass('is-active');  
        }

        $(this).next().slideToggle(300);

        if ($(this).find('.jfu-toggle-trigger-icon').hasClass('is-active')) {
          $(this).find('.jfu-toggle-trigger-icon').removeClass('is-active');
        }
        else {                 
          $(this).find('.jfu-toggle-trigger-icon').addClass('is-active');
        }
      });


      $( '.basepack-accordion-wrapper' ).each(function(i) {
        let itemsInitialState = $(this).attr('data-accordion');
        if (itemsInitialState == "first-open") {
          let accordionItem = $(this).find('.basepack-accordion-item');
          accordionItem.find('.basepack-accordion-item--title-container').removeClass('is-active');
          accordionItem.first().find('.basepack-accordion-item--title-container').addClass('is-active');
          accordionItem.first().find('.basepack-accordion-item--content').css("display", "block");
        } else if (itemsInitialState == "all-open") {
          let accordionItem = $(this).find('.basepack-accordion-item');
          accordionItem.find('.basepack-accordion-item--title-container').addClass('is-active');
          accordionItem.find('.basepack-accordion-item--content').css("display", "block");
        } else if (itemsInitialState == "all-closed") {
          let accordionItem = $(this).find('.basepack-accordion-item');
          accordionItem.find('.basepack-accordion-item--title-container').removeClass('is-active');
          accordionItem.find('.basepack-accordion-item--content').css("display", "none");
        };

      });


    }
  };
})(jQuery);
