(function ($) {
  Drupal.behaviors.basepack_slideshow = {
    attach: function (context, settings) {
      $(once('castorcito-basepack-slideshow', '.basepack-slideshow--slick-wrapper .basepack-slideshow--slick', context)).each(function(index) {
        const vertical = $(this).attr('data-direction') == 'up_to_down' ? true : false;
        let bullets = $(this).attr('data-bullets') == 0 ? true : false;
        let numbers = false;

        if ($(this).attr('data-numbers') == 1) {
          bullets = true;
          numbers = true;
        }

        $(this).not('.slick-initialized').slick({
          arrows: $(this).attr('data-arrows') == 0 ? true : false,
          dots: bullets,
          infinite: $(this).attr('data-loop') == 0 ? true : false,
          slidesToShow: 1,
          speed: 1500,
          autoplay: $(this).attr('data-autoplay') == 0 ? true : false,
          autoplaySpeed: $(this).attr('data-sspeed'),
          vertical: vertical,
          verticalSwiping: vertical,
          customPaging: function (slider, i) {
            if (numbers) {
              return `<button class="custom-dot">${i + 1}</button>`;
            } else {
              return `<button class="dot">item</button>`;
            };
          }
        });
      });
    }
  };

})(jQuery);
