<?php

namespace Drupal\castorcito;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Defines the interface for plugin.
 */
interface CastorcitoComponentFieldInterface extends PluginInspectionInterface, ConfigurableInterface {

  /**
   * Returns the plugin label.
   *
   * @return string
   *   The plugin label.
   */
  public function label();

  /**
   * Define a model for the model field.
   *
   * @return array
   *   Model array.
   */
  public function defaultModel();

  /**
   * Returns the field label.
   *
   * @return string
   *   The field label.
   */
  public function getFieldLabel();

  /**
   * Sets the field label for this component.
   *
   * @param srring $label
   *   The field label.
   */
  public function setFieldLabel($label);

  /**
   * Returns the field name.
   *
   * @return string
   *   The field name.
   */
  public function getFieldName();

}
