# Castorcito
Castorcito allows you to create custom components according to the different needs that your web project may require.
That is why castorcito contains a set of pre-designed components such as Banners, Tabs, Accordions, Quotes, Cards, among others.
To obtain this package of components you must activate the module castorcito_basepack. For a better understanding of the creation of components, you can review the components generated by castorcito_basepack.
If you plan to use one of these components, we recommend you to clone the component and use the clone, this way you will have more control and always keep a backup of the original.

**Note:** This module is currently incompatible with the Klaro Cookie & Consent Manager contrib module. Klaro Cookie & Consent Manager is installed by default in Drupal CMS.

## How to use Castorcito components
Castorcito module allows us to use reusable “components” like banners, quotes, images with text, accordions, tabs and so on, in a JSON field. When you install Castorcito module it add a widget and formatter to JSON field. You also have an administrative interface to list, edit o create new components.

To use Castorcito components, you will need to follow a few simple steps:

- Ensure you have at least one castorcito component: First, verify that a component is available at `admin/castorcito/component`. If you don't find one, you'll need to create it or install a module like castorcito_basepack.
- Create Your Field: Next, add a new field to your desired entity. This field must be of type `JSON (raw), JSON (text), or JSONB/JSON (raw)`. After selecting the type, save the field's configurations.
- Select "Castorcito Component" Widget: Navigate to the Managed Form Display settings. Here, select `Castorcito Component` widget. You also need to configure the widget options where you can specify exactly which Castorcito component you want to link to this field.
- Select "Castorcito Component" Formatter: Finally, go to the Managed Display settings. Make sure to select the `Castorcito component` formatter and then save your changes.

## Managing templates

### Single directory component(SDC) integration
Each component offers an option to select an SDC using the `Single Directory Component` setting. If no SDC is explicitly chosen, the Castorcito core's default SDC will be applied. This default SDC provides a basic markup structure.

### Available props for SDC twig templates
The following properties are available for use within your SDC Twig templates:

- `component_data`: An associative array containing the data to be rendered by the component.
- `display_settings`: An associative array with the display configuration for all component fields that have defined display settings.
- `attributes`: An instance of `Drupal\Core\Template\Attribute` containing the HTML attributes to apply to the component's wrapper element.
- `cfield_plugins`: An associative array containing the specific configuration of plugins of type `CastorcitoComponentField`.

### How to overwrite this markup?
You have to copy the SDC files from the origin module and paste into the theme "componentes" directory (see https://www.drupal.org/docs/develop/theming-drupal/using-single-directory-components/creating-a-single-directory-component). after that you only have to add a key and value (replaces) in the .component.yml file
```
replaces: 'castorcito:name-sdc'
```
For example if you want to overwrite the markup from castorcito_plain_text SDC you have to copy the directory with the fields from the core of castorcito and paste in mycustom_theme/components/castorcito_plain_text/  and inside its .component.yml add the line replaces: 'castorcito:castorcito_plain_text'

After added this values you can make all the changes you want from the theme.

# Castorcito_basepack
This castorcito submodule add many default components to be used in multiple scenaries, every one has its own cfields, its configuration and its components files (SDC).
Every component has a default look and feel to be adapted in any current theme, some of them components also include js code to get the properly behaviour.
Be free to test them!


## How to overwrite this components markup?
It's the same way to overwrite cfields, you only have to copy the SDC related to a castorcito_basepack component from the module to the theme and then define the replaces key and value

For example:
Copy the SDC from castorcito/modules/castorcito_basepack/components/basepack_quote/ to custom_theme/components/basepack_quote/ and then you only have to add a key and value (replaces) in the .component.yml file
```
replaces: 'castorcito_basepack:basepack_quote'
```

After added this values you can make all the changes you want from the theme.


# Process of upgrading from 1.0.0-alpha1 to latest

- Install config_delete module
- Delete config REST resource block_list_resource
- Upgrade to latest version with composer or git if use dev version
- Go to /update.php

# Installing JSON Editor with composer

One of the dependencies of this module is [json_field], this module adds a solution for adding jsoneditor to a site using Composer.
This solution can be found in the [README.md] of the [json_field] module in the "Installing JSON Editor with composer" section.
