export default {
  props: ['fieldModel', 'componentFieldSettings', 'fieldBaseName', 'fieldName'],
  data() {
    const isTextarea = this.componentFieldSettings.settings.field_type === 'textarea' ? true : false;
    const isText = this.componentFieldSettings.settings.field_type === 'text' ? true : false;
    return {
      isTextarea: isTextarea,
      isText: isText,
      isRequired: this.componentFieldSettings.required
    };
  },
  template: `
    <div :class="['js-form-wrapper form-wrapper', {'field--type-string field--widget-string-textfield': isText, 'field--type-string-long field--widget-string-textarea': isTextarea}]">
      <div :class="['js-form-item form-item', {'js-form-type-textfield form-type--textfield': isText, 'js-form-type-textarea form-type--textarea': isTextarea}]">
        <label v-if="!componentFieldSettings.hide_label" :for="fieldName" class="form-item__label" :class="{'form-required': isRequired }">{{ componentFieldSettings.label }}</label>
        <input v-if="isText" :id="fieldName" :name="fieldName" v-model="fieldModel.value" type="text" size="60" maxlength="255" class="js-text-full text-full form-text form-element form-element--type-text form-element--api-textfield" :required="isRequired" />
        <div v-if="isTextarea" class="form-textarea-wrapper">
          <textarea class="js-text-full text-full form-textarea resize-vertical form-element form-element--type-textarea form-element--api-textarea" :id="fieldName" :name="fieldName" v-model="fieldModel.value" rows="5" cols="60" placeholder="" :required="isRequired"></textarea>
        </div>
        <div class="form-item__description">{{ componentFieldSettings.description }}</div>
      </div>
    </div>
  `
};
