<?php

namespace Drupal\castorcito_sync\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\system\FileDownloadController;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Returns responses for config module routes.
 */
class CastorcitoSyncController extends ControllerBase {

  /**
   * The file download controller.
   *
   * @var \Drupal\system\FileDownloadController
   */
  protected $fileDownloadController;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      FileDownloadController::create($container),
    );
  }

  /**
   * Constructs a CastorcitoExportController object.
   *
   * @param \Drupal\system\FileDownloadController $file_download_controller
   *   The file download controller.
   */
  public function __construct(FileDownloadController $file_download_controller) {
    $this->fileDownloadController = $file_download_controller;
  }

  /**
   * Downloads a tarball of the site configuration.
   */
  public function downloadExport() {
    $request = new Request(['file' => 'config.tar.gz']);
    return $this->fileDownloadController->download($request, 'temporary');
  }

}
