<?php

namespace Drupal\castorcito\Plugin\CastorcitoComponentField;

use Drupal\Core\Form\FormStateInterface;
use Drupal\castorcito\ConfigurableComponentFieldBase;

/**
 * Number configuration.
 *
 * @CastorcitoComponentField(
 *   id = "number",
 *   label = @Translation("Number"),
 *   description = @Translation("Configuration for the number field.")
 * )
 */
class Number extends ConfigurableComponentFieldBase {

  /**
   * {@inheritdoc}
   */
  public function defaultModel() {
    return [
      'value' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return parent::defaultConfiguration() + [
      'min' => '',
      'max' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['min'] = [
      '#type' => 'number',
      '#title' => $this->t('Min'),
      '#default_value' => $this->configuration['min'],
      '#description' => $this->t('The minimum value that should be allowed in this field. Leave blank for no minimum.'),
    ];

    $form['max'] = [
      '#type' => 'number',
      '#title' => $this->t('Max'),
      '#default_value' => $this->configuration['max'],
      '#description' => $this->t('The maximum value that should be allowed in this field. Leave blank for no maximum.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    $this->configuration['min'] = $form_state->getValue('min');
    $this->configuration['max'] = $form_state->getValue('max');
  }

  /**
   * {@inheritdoc}
   */
  public function overridableConfiguration() {
    return parent::overridableConfiguration() + [
      'min',
      'max',
    ];
  }

}
