<?php

namespace Drupal\castorcito\Plugin\CastorcitoComponentField;

use Drupal\Core\Form\FormStateInterface;
use Drupal\castorcito\ConfigurableComponentFieldBase;

/**
 * Plain Text configuration.
 *
 * @CastorcitoComponentField(
 *   id = "plain_text",
 *   label = @Translation("Plain text"),
 *   description = @Translation("Configuration for the simple text field.")
 * )
 */
class PlainText extends ConfigurableComponentFieldBase {

  /**
   * {@inheritdoc}
   */
  public function defaultModel() {
    return [
      'value' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return parent::defaultConfiguration() + [
      'field_type' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['field_type'] = [
      '#type' => 'select',
      '#title' => $this->t('Select field type'),
      '#default_value' => $this->configuration['field_type'],
      '#required' => TRUE,
      '#options' => [
        'text' => $this->t('Text (plain text)'),
        'textarea' => $this->t('Text (normal, long)'),
      ],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    $this->configuration['field_type'] = $form_state->getValue('field_type');
  }

}
