<?php

namespace Drupal\castorcito;

use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a base class for configurable component fields.
 *
 * @see \Drupal\castorcito\Annotation\CastorcitoComponentField
 * @see \Drupal\castorcito\ConfigurableComponentFieldInterface
 * @see \Drupal\castorcito\CastorcitoComponentFieldInterface
 * @see \Drupal\castorcito\CastorcitoComponentFieldBase
 * @see \Drupal\castorcito\CastorcitoComponentFieldManager
 * @see plugin_api
 */
abstract class ConfigurableComponentFieldBase extends CastorcitoComponentFieldBase implements ConfigurableComponentFieldInterface {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
  }

  /**
   * Returns an array of configuration values that can be overridden in the Drupal widget.
   *
   * @see \Drupal\castorcito\Plugin\CastorcitoComponentField\Image;
   * @see \Drupal\castorcito\Plugin\CastorcitoComponentField\Container;
   *
   */
  public function overridableConfiguration() {
    return [];
  }

}
