<?php

namespace Drupal\castorcito\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\castorcito\CastorcitoCategoryInterface;

/**
 * Defines the castorcito category entity type.
 *
 * @ConfigEntityType(
 *   id = "castorcito_category",
 *   label = @Translation("Castorcito category"),
 *   label_collection = @Translation("Castorcito categories"),
 *   label_singular = @Translation("castorcito category"),
 *   label_plural = @Translation("castorcito categories"),
 *   label_count = @PluralTranslation(
 *     singular = "@count castorcito category",
 *     plural = "@count castorcito categories",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\castorcito\CastorcitoCategoryListBuilder",
 *     "form" = {
 *       "add" = "Drupal\castorcito\Form\CastorcitoCategoryForm",
 *       "edit" = "Drupal\castorcito\Form\CastorcitoCategoryForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *   },
 *   config_prefix = "castorcito_category",
 *   admin_permission = "administer castorcito_category",
 *   links = {
 *     "collection" = "/admin/castorcito/component/category",
 *     "add-form" = "/admin/castorcito/component/category/add",
 *     "edit-form" = "/admin/castorcito/component/category/{castorcito_category}",
 *     "delete-form" = "/admin/castorcito/component/category/{castorcito_category}/delete",
 *   },
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "description",
 *   },
 * )
 */
class CastorcitoCategory extends ConfigEntityBase implements CastorcitoCategoryInterface {

  /**
   * The example ID.
   */
  protected string $id;

  /**
   * The example label.
   */
  protected string $label;

  /**
   * The example description.
   */
  protected string $description;

}
