<?php

namespace Drupal\castorcito\Plugin\CastorcitoComponentField;

use Drupal\Core\Form\FormStateInterface;
use Drupal\castorcito\ConfigurableComponentFieldBase;

/**
 * Provides configuration for a link field.
 *
 * @CastorcitoComponentField(
 *   id = "link",
 *   label = @Translation("Link"),
 *   description = @Translation("Configuration for the link field.")
 * )
 */
class Link extends ConfigurableComponentFieldBase {

  /**
   * {@inheritdoc}
   */
  public function defaultModel() {
    return [
      'value' => '',
      'text' => '',
      'target' => '',
      'external' => TRUE,
      'relative' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'allow_link_text' => 1,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['allow_link_text'] = [
      '#type' => 'radios',
      '#title' => $this->t('Allow link text'),
      '#default_value' => $this->configuration['allow_link_text'] ?? 1,
      '#options' => [
        DRUPAL_DISABLED => $this->t('Disabled'),
        DRUPAL_OPTIONAL => $this->t('Optional'),
        DRUPAL_REQUIRED => $this->t('Required'),
      ],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    $this->configuration['allow_link_text'] = $form_state->getValue('allow_link_text');
  }

  /**
   * {@inheritdoc}
   */
  public function overridableConfiguration() {
    return parent::overridableConfiguration() + [
      'allow_link_text',
    ];
  }

}
