<?php

namespace Drupal\castorcito\Form;

use Drupal\castorcito\CastorcitoComponentFieldManager;
use Drupal\castorcito\CastorcitoComponentInterface;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides an add form for component field.
 *
 * @internal
 */
class CastorcitoComponentFieldEditForm extends CastorcitoComponentFieldFormBase {

  /**
   * The component field manager.
   *
   * @var \Drupal\castorcito\CastorcitoComponentFieldManager
   */
  protected $componentFieldManager;

  /**
   * Constructs a new ComponentFieldAddForm.
   *
   * @param \Drupal\castorcito\CastorcitoComponentFieldManager $component_field_manager
   *   The component field manager.
   */
  public function __construct(CastorcitoComponentFieldManager $component_field_manager) {
    $this->componentFieldManager = $component_field_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('plugin.manager.castorcito_component_field')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, CastorcitoComponentInterface $castorcito_component = NULL, $field_type = NULL, $field_id = NULL) {
    $form = parent::buildForm($form, $form_state, $castorcito_component, $field_type, $field_id);

    $form['#title'] = $this->t('Edit %label field to %component component', [
      '%label' => $this->componentField->label(),
      '%component' => $this->component->label(),
    ]);
    $form['actions']['submit']['#value'] = $this->t('Update');

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  protected function prepareComponentField($field_type) {
    $field = $this->component->getComponentField($field_type);
    return $field;
  }

}
