<?php

namespace Drupal\castorcito\Plugin\CastorcitoComponentField;

use Drupal\Core\Field\FieldFilteredMarkup;
use Drupal\Core\Form\FormStateInterface;
use Drupal\castorcito\ConfigurableComponentFieldBase;

/**
 * Provides configuration for an iframe field.
 *
 * @CastorcitoComponentField(
 *   id = "iframe",
 *   label = @Translation("Iframe"),
 *   description = @Translation("Configuration for the iframe field.")
 * )
 */
class Iframe extends ConfigurableComponentFieldBase {

  /**
   * {@inheritdoc}
   */
  public function defaultModel() {
    return [
      'option' => '',
      'url' => '',
      'value' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return parent::defaultConfiguration() + [
      'options' => [],
      'vimeo_options' => [],
      'youtube_options' => [],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['options'] = [
      '#type' => 'checkboxes',
      '#options' => [
        'iframe' => $this->t('Iframe'),
        'vimeo' => $this->t('Vimeo'),
        'youtube' => $this->t('YouTube'),
      ],
      '#title' => $this->t('Options'),
      '#default_value' => $this->configuration['options'],
      '#description' => $this->t('Restrict users from entering information from the following providers. If none are selected any video provider can be used.'),
      '#required' => TRUE,
    ];

    $form['vimeo_options'] = [
      '#type' => 'details',
      '#title' => $this->t('Vimeo options'),
      '#states' => [
        'visible' => [
          ':input[name="settings[options][vimeo]"]' => ['checked' => TRUE],
        ],
      ],
    ];

    $form['vimeo_options']['width'] = [
      '#type' => 'number',
      '#title' => $this->t('Width'),
      '#default_value' => $this->configuration['vimeo_options']['width'] ?? 640,
      '#description' => $this->t('Allows you to define a width for the video.'),
    ];

    $form['vimeo_options']['height'] = [
      '#type' => 'number',
      '#title' => $this->t('Height'),
      '#default_value' => $this->configuration['vimeo_options']['height'] ?? 360,
      '#description' => $this->t('Allows you to define a height for the video.'),
    ];

    $form['vimeo_options']['vimeo_details'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Vimeo help text'),
      '#default_value' => $this->configuration['vimeo_options']['vimeo_details'] ?? '',
      '#description' => $this->t('Instructions to present to the user below this field on the editing form.<br />Allowed HTML tags: @tags', ['@tags' => FieldFilteredMarkup::displayAllowedTags()]) . '<br />',
    ];

    $form['youtube_options'] = [
      '#type' => 'details',
      '#title' => $this->t('YouTube options'),
      '#states' => [
        'visible' => [
          ':input[name="settings[options][youtube]"]' => ['checked' => TRUE],
        ],
      ],
    ];

    $form['youtube_options']['autoplay'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Autoplay'),
      '#default_value' => isset($this->configuration['youtube_options']['autoplay']) ? $this->configuration['youtube_options']['autoplay'] : FALSE,
      '#description' => $this->t('Automatically start the video when the page loads.'),
    ];

    $form['youtube_options']['mute'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Mute'),
      '#default_value' => isset($this->configuration['youtube_options']['mute']) ? $this->configuration['youtube_options']['mute'] : FALSE,
      '#description' => $this->t('Start the video with sound muted.'),
    ];

    $form['youtube_options']['loop'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Loop'),
      '#default_value' => isset($this->configuration['youtube_options']['loop']) ? $this->configuration['youtube_options']['loop'] : FALSE,
      '#description' => $this->t('Repeat the video when it ends.'),
    ];

    $form['youtube_options']['rel'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Rel'),
      '#default_value' => isset($this->configuration['youtube_options']['rel']) ? $this->configuration['youtube_options']['rel'] : FALSE,
      '#description' => $this->t('Limit suggested videos to this channel only (YouTube does not allow complete removal).'),
    ];

    $form['youtube_options']['controls'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Controls'),
      '#default_value' => isset($this->configuration['youtube_options']['controls']) ? $this->configuration['youtube_options']['controls'] : FALSE,
      '#description' => $this->t('Hide video player controls.'),
    ];

    $form['youtube_options']['width'] = [
      '#type' => 'number',
      '#title' => $this->t('Width'),
      '#default_value' => $this->configuration['youtube_options']['width'] ?? 640,
      '#description' => $this->t('Allows you to define a width for the video.'),
    ];

    $form['youtube_options']['height'] = [
      '#type' => 'number',
      '#title' => $this->t('Height'),
      '#default_value' => $this->configuration['youtube_options']['height'] ?? 360,
      '#description' => $this->t('Allows you to define a height for the video.'),
    ];

    $form['youtube_options']['youtube_details'] = [
      '#type' => 'textarea',
      '#title' => $this->t('YouTube help text'),
      '#default_value' => $this->configuration['youtube_options']['youtube_details'] ?? '',
      '#description' => $this->t('Instructions to present to the user below this field on the editing form.<br />Allowed HTML tags: @tags', ['@tags' => FieldFilteredMarkup::displayAllowedTags()]) . '<br />',
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    $this->configuration['options'] = array_filter($form_state->getValue('options'));
    $this->configuration['vimeo_options'] = $form_state->getValue('vimeo_options');
    $this->configuration['youtube_options'] = $form_state->getValue('youtube_options');
  }

   /**
   * {@inheritdoc}
   */
  public function overridableConfiguration() {
    return parent::overridableConfiguration() + [
      'vimeo_options',
      'youtube_options',
    ];
  }

}
