const { defineAsyncComponent, markRaw } = Vue;

export default {
  props: ['formData', 'cFieldComponents', 'fieldBaseName', 'containerDelta'],
  data() {
    return {
      showEditName: true,
      defaultTranslations: drupalSettings.default_translations,
    };
  },
  computed: {
    buttonLabel() {
      return this.showEditName ? this.defaultTranslations.show_name_editing : this.defaultTranslations.hide_name_editing;
    },
    enableEditName() {
      return this.formData.componentOverriddenSettings?.settings?.enable_edit_name ?? this.formData.fieldsSettings.settings.enable_edit_name;
    },
  },
  template: `
    <div class="castorcito-form--fields">
      <div v-if="enableEditName" class="form-item">
        <label :for="fieldBaseName + '_label_' + containerDelta" class="form-item__label">{{ formData.componentModel.label }}</label>
        <button type="button" class="link action-link tabledrag-toggle-weight castorcito-edit-name" @click="toggleEditName">
          <span :class="['action-link action-link--extrasmall tabledrag-toggle-weight', {'action-link--icon-show': showEditName, 'action-link--icon-hide': !showEditName}]">{{ buttonLabel }}</span>
        </button>
        <input :id="fieldBaseName + '_label_' + containerDelta" :name="fieldBaseName + '_label_' + containerDelta" type="text" v-model="formData.componentModel.label" size="60" maxlength="255" :class="['text-full form-text form-element form-element--type-text form-element--api-textfield', {'hidden': showEditName}]" />
      </div>
      <div v-for="(field, index) in formData.componentModel.fields" :key="formData.componentId + '_' + index" :data-field-name="index">
        <component
          :is="cFieldComponents[field.type]"
          :fieldModel="field"
          :componentFieldSettings="cfieldSettings(index)"
          :overriddenCFieldSettings="formData.componentOverriddenSettings?.cfields?.[index]"
          :fieldBaseName="fieldBaseName"
          :fieldName="fieldName(index)"
          @reset_conditional_fields="resetConditionalFields" />
      </div>
    </div>
  `,
  methods: {
    fieldName(name) {
      return `${this.fieldBaseName}_${name}_${this.containerDelta}`;
    },
    toggleEditName() {
      this.showEditName = !this.showEditName;
    },
    resetConditionalFields(fields) {
      const componentId = this.formData.componentModel.type;
      const model = drupalSettings.components[componentId];

      fields.forEach(field => {
        this.formData.componentModel.fields[field] = model.fields[field];
      });
    },
    deepMerge(target, source) {
      for (const key in source) {
        if (source[key] instanceof Object && key in target && target[key] instanceof Object) {
          this.deepMerge(target[key], source[key]);
        } else {
          target[key] = source[key];
        }
      }

      return target;
    },
    cfieldSettings(cfield) {
      const cfieldsSettings = this.formData.fieldsSettings['fields'][cfield];
      const overriddenCFieldSettings = this.formData.componentOverriddenSettings?.cfields?.[cfield];

      return overriddenCFieldSettings
        ? this.deepMerge({ ...cfieldsSettings }, overriddenCFieldSettings)
        : cfieldsSettings;
    }
  }
};
