<?php

namespace Drupal\castorcito\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a component field annotation object.
 *
 * Plugin Namespace: Plugin\ComponentField.
 *
 * @Annotation
 */
class CastorcitoComponentField extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the component field.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A brief description of the component field.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * This property is optional and it does not need to be declared.
   *
   * This will be shown when adding or configuring this component field.
   *
   * @ingroup plugin_translatable
   */
  public $description = '';

}
