<?php

namespace Drupal\castorcito;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface defining a Castorcito component entity type.
 */
interface CastorcitoComponentInterface extends ConfigEntityInterface {

  /**
   * Get model of the component.
   *
   * @return array
   *   array model.
   */
  public function getModel();

  /**
   * Sets the component model.
   *
   * @param array $model
   *   The model of the component.
   *
   * @return $this
   *   The class instance this method is called on.
   */
  public function setModel($model);

  /**
   * Create the model of the component.
   *
   * @param string $label
   *   The component label.
   *
   * @return $this
   *   The class instance this method is called on.
   */
  public function setBaseModel($label);

  /**
   * Sets the field of the component.
   *
   * @param string $name
   *   The name of the field.
   * @param string $field_model
   *   The model of the field.
   *
   * @return $this
   *   The class instance this method is called on.
   */
  public function setModelField($name, $field_model);

  /**
   * Sets the display settings values for the component.
   *
   * @param array $values
   *   An associative array of display settings values.
   *
   * @return $this
   *   The class instance this method is called on.
   */
  public function setComponentDisplaySettingsValues(array $values);

  /**
   * Update an display settings for component.
   *
   * @param array $settings
   *   An array of settings.
   *
   * @return string
   *   This component.
   */
  public function updateComponentDisplaySettings(array $settings);

  /**
   * Returns a specific field configuration.
   *
   * @param string $field
   *   The field machine name.
   *
   * @return \Drupal\castorcito\CastorcitoComponentFieldInterface
   *   The component field object.
   */
  public function getComponentField($field);

  /**
   * Returns the field configuration for component.
   *
   * @return \Drupal\castorcito\CastorcitoComponentFieldPluginCollection|\Drupal\castorcito\CastorcitoComponentFieldInterface[]
   *   The component field plugin collection.
   */
  public function getComponentFields();

  /**
   * Saves an field for component.
   *
   * @param array $configuration
   *   An array of field configuration.
   *
   * @return string
   *   The field name.
   */
  public function addComponentField(array $configuration);

  /**
   * Deletes an field from this component.
   *
   * @param \Drupal\castorcito\CastorcitoComponentFieldInterface $field
   *   The component field object.
   *
   * @return $this
   */
  public function deleteComponentField(CastorcitoComponentFieldInterface $field);

}
