<?php

namespace Drupal\castorcito\Form;

use Drupal\Core\Form\FormStateInterface;

/**
 * Controller for castorcito component addition forms.
 *
 * @internal
 */
class CastorcitoComponentAddForm extends CastorcitoComponentFormBase {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);
    $form['component_info']['#open'] = TRUE;

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $this->entity->setBaseModel();
    $this->messenger()->addStatus($this->t('Component %name was created.', ['%name' => $this->entity->label()]));
  }

  /**
   * {@inheritdoc}
   */
  public function actions(array $form, FormStateInterface $form_state) {
    $actions = parent::actions($form, $form_state);
    $actions['submit']['#value'] = $this->t('Create new component');

    return $actions;
  }

}
