(function ($) {
  Drupal.behaviors.basepack_carousel = {
    attach: function (context, settings) {
      $(once('castorcito-basepack-carousel', '.basepack-carousel-wrapper .basepack-carousel-items', context)).each(function(index) {
        $(this).not('.slick-initialized').slick({
          dots: true,
          slidesToShow: $(this).attr('data-items').length ? $(this).attr('data-items') : 3,
          autoplay: $(this).attr('data-autoplay') == 0 ? false : true,
          autoplaySpeed: $(this).attr('data-delay').length ? $(this).attr('data-delay') : 300,
          responsive: [
            {
              breakpoint: 992,
              settings: {
                slidesToShow: 2,
                slidesToScroll: 1,
              }
            },
            {
              breakpoint: 768,
              settings: {
                slidesToShow: 1,
                slidesToScroll: 1,
              }
            },
          ],
        });
      });
    }
  };

})(jQuery);
