<?php

namespace Drupal\castorcito\Form;

use Drupal\castorcito\CastorcitoComponentInterface;
use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form for deleting an component field.
 *
 * @internal
 */
class CastorcitoComponentFieldDeleteForm extends ConfirmFormBase {

  /**
   * The Component.
   *
   * @var \Drupal\castorcito\CastorcitoComponentInterface
   */
  protected $component;

  /**
   * The Component field.
   *
   * @var \Drupal\castorcito\CastorcitoComponentFieldInterface
   */
  protected $componentField;

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete the @field field from the %component component?',
      [
        '%component' => $this->component->label(),
        '@field' => $this->componentField->getFieldLabel(),
      ]
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return $this->component->toUrl('edit-form');
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'component_field_delete_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, CastorcitoComponentInterface $castorcito_component = NULL, $field_type = NULL) {
    $this->component = $castorcito_component;
    $this->componentField = $this->component->getComponentField($field_type);

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->component->deleteComponentField($this->componentField);
    $this->messenger()->addStatus($this->t('The field %name has been deleted.', ['%name' => $this->componentField->getFieldLabel()]));
    $form_state->setRedirectUrl($this->component->toUrl('edit-form'));
  }

}
