export default {
  props: ['fieldModel', 'componentFieldSettings', 'fieldName'],
  data() {
    return {
      isRequired: this.componentFieldSettings.required
    };
  },
  template: `
    <div class="form-item form-type--number">
      <label :for="fieldName" class="form-item__label" :class="{'form-required': isRequired }">{{ componentFieldSettings.label }}</label>
      <input
        type="number"
        :id="fieldName"
        :name="fieldName"
        v-model="fieldModel.value"
        step="1"
        :min="componentFieldSettings.settings.min"
        :max="componentFieldSettings.settings.max"
        placeholder=""
        class="form-number form-element form-element--type-number form-element--api-number"
        :class="{'required': isRequired }"
        :required="isRequired"
      >
      <div class="form-item__description">{{ componentFieldSettings.description }}</div>
    </div>
  `
};
