<?php

namespace Drupal\castorcito_webform\Plugin\CastorcitoComponentField;

use Drupal\castorcito\ConfigurableComponentFieldBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Webform configuration.
 *
 * @CastorcitoComponentField(
 *   id = "webform",
 *   label = @Translation("Webform"),
 *   description = @Translation("Configuration for the webform field.")
 * )
 */
class Webform extends ConfigurableComponentFieldBase {

  #[\Override]
  public function defaultModel() {
    return [
      'value' => '',
      'webform_id' => '',
    ];
  }

  #[\Override]
  public function defaultConfiguration() {
    return parent::defaultConfiguration();
  }

  #[\Override]
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {}

}
