<?php

namespace Drupal\castorcito;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Manages castorcito component field plugins
 */
class CastorcitoComponentFieldManager extends DefaultPluginManager {

  /**
   * Constructs a new CastorcitoComponentFieldManager.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/CastorcitoComponentField',
      $namespaces,
      $module_handler,
      'Drupal\castorcito\CastorcitoComponentFieldInterface',
      'Drupal\castorcito\Annotation\CastorcitoComponentField'
    );
    $this->alterInfo('castorcito_component_field_info');
    $this->setCacheBackend($cache_backend, 'castorcito_component_field_plugins');
  }

}
