<?php

namespace Drupal\cdnetworks_purge\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Build CDNetworks admin form UI.
 */
class ConfigForm extends ConfigFormBase {

  const CONFIG_NAME = 'cdnetworks_purge.settings';

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'cdnetworks_purge_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [self::CONFIG_NAME];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->getConfig();

    $form['base_uri'] = [
      '#type' => 'textfield',
      '#title' => $this->t('CDNetworks Base REST URI'),
      '#default_value' => $config->get('base_uri'),
      '#description' => $this->t('Do not include trailing slash. Ex. https://api.cdnetworks.com'),
      '#required' => TRUE,
    ];

    $form['username'] = [
      '#type' => 'key_select',
      '#title' => $this->t('CDNetworks Username'),
      '#default_value' => $config->get('username'),
      '#empty_option' => $this->t('- Select -'),
      '#required' => TRUE,
    ];

    $form['apikey'] = [
      '#type' => 'key_select',
      '#title' => $this->t('CDNetworks APIkey'),
      '#default_value' => $config->get('apikey'),
      '#empty_option' => $this->t('- Select -'),
      '#required' => TRUE,
    ];

    $form['cdn_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Accelerated CDNetworks domain'),
      '#default_value' => $config->get('cdn_url'),
      '#description' => $this->t('Do not include http:// or https://. Ex. www.example.com'),
      '#required' => TRUE,
    ];

    $form['optional'] = [
      '#type' => 'details',
      '#title' => $this->t('Optional Configuration'),
      '#open' => TRUE,
    ];

    $form['optional']['cachetag'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Cache Tag headers'),
      '#default_value' => $config->get('cachetag'),
      '#description' => $this->t('Select if you want to generate Cache Tag header for CDNetworks'),
    ];

    $form['optional']['ideal_conditions_limit'] = [
      '#type' => 'number',
      '#title' => $this->t('Ideal Conditions Limit'),
      '#default_value' => $config->get('ideal_conditions_limit'),
      '#description' => $this->t('This limit is used to control how many items the system can invalidate at a time.'),
    ];

    $form['optional']['verbose_log'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Verbose logging'),
      '#default_value' => $config->get('verbose_log'),
      '#description' => $this->t('Select if you want to provide verbose logging.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->getConfig();
    $values = $form_state->getValues();
    $config->set('username', $values['username']);
    $config->set('apikey', $values['apikey']);
    $config->set('cachetag', $values['cachetag']);
    $config->set('ideal_conditions_limit', (int) $values['ideal_conditions_limit']);
    $config->set('cdn_url', $values['cdn_url']);
    $config->set('base_uri', $values['base_uri']);
    $config->set('verbose_log', $values['verbose_log']);
    $config->save();
  }

  /**
   * Returns this modules configuration object.
   */
  protected function getConfig() {
    return $this->config(self::CONFIG_NAME);
  }

}
