# Certificate Login

*This is the Drupal 8 documentation.  For Drupal 7, see [the Drupal 7 documentation](http://cgit.drupalcode.org/certificatelogin/tree/README.txt?h=7.x-2.x).*

## Description

This module allows users to log into your site securely *without usernames and passwords*. It uses digital/identity certificates users have imported into their browsers as part of a [public key infrastructure (PKI)](https://en.wikipedia.org/wiki/Public_key_infrastructure). The certificates can be generated by Drupal's [PKI Registration Authority](https://www.drupal.org/project/pki_ra) module or any other registration authority (RA) / certification authority (CA).

## Functionality

What this module does:

* Adds a login-with-certificate link to the standard user-login form.
* If a certificate was found and it authenticates (based on your configuration), the user is logged in.
* If the user doesn't have an account yet, it's automatically created so there's no reason to register separately with this method.

## Requirements

* A Web server that can be configured to support client authentication.
* An HTTPS-enabled site as client authentication cannot be enabled over HTTP.
* The [External Authentication](https://www.drupal.org/project/externalauth) Drupal module.
* [Composer](https://getcomposer.org/) and the [phpseclib](http://phpseclib.sourceforge.net/) PHP library if you'd like to restrict user logins to users having certificates from a particular CA, and want to use the built-in default plug-in for verifying CA signatures on client certificates.
* Users must have their certificates imported into their browsers before accessing the site.

## Installation

1. If you don't have an HTTPS site certificate, get set up with [Certbot](https://certbot.eff.org/), which provides [Let's Encrypt](https://letsencrypt.org/) certificates.  (This is done for you automatically if your site is hosted on [Aegir](https://en.wikipedia.org/wiki/Aegir_Hosting_System) with [Aegir HTTPS](https://gitlab.com/aegir/hosting_https).)
1. Configure your Web server virtual host as follows. We're assuming you're running Nginx with [the standard Drupal configuration](https://www.nginx.com/resources/wiki/start/topics/recipes/drupal/).  If you're not, do something similar with Apache, [Caddy](https://en.wikipedia.org/wiki/Caddy_(web_server)), etc.
    * `# Enable client authentication (with your other HTTPS settings)`
    * `ssl_verify_client optional_no_ca;`
    * `# Pass the server variable containing the certificate to Drupal (in your PHP location block)`
    * `fastcgi_param CLIENT_CERTIFICATE $ssl_client_raw_cert;`
1. To verify CA signatures on client certificates using `phpseclib`, follow [phpseclib's installation instructions](https://github.com/phpseclib/phpseclib#20) ensuring that you're running Composer commands from your Drupal root directory. (The following was up-to-date at the time of this writing.)
    * `composer require phpseclib/phpseclib \~2.0`
1. [Install and enable](https://www.drupal.org/docs/8/extending-drupal-8/installing-drupal-8-modules) this module on your Drupal site.
1. Surf to Administration » Configuration » People » Certificate Login.
1. Configure all settings before enabling the functionality with the *Enabled* checkbox at the top.
