<?php

/**
 * @file
 * Hooks for the Content Guide module.
 */

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Alter javascript settings used to generate the content guide.
 *
 * @param array $settings_js
 *   Javascript settings for a field.
 * @param array $context
 *   Additional information useful when altering the settings.
 */
function hook_cg_field_settings_alter(array &$settings_js, array $context): void {
  if ('my_field' === $context['field_name']) {
    // Force the Content Guide to be attach as a tooltip to the first <h2> in
    // the field widgets output.
    $settings_js['attachSelector'] = 'h2:first-of-type';
    $settings_js['cg']['display_type'] = 'tooltip';
  }
}

/**
 * Alter javascript settings used to generate the content guide for a field.
 *
 * @param array $settings_js
 *   Javascript settings for a field.
 * @param array $context
 *   Additional information useful when altering the settings.
 */
function hook_cg_field_my_field_settings_alter(array &$settings_js, array $context): void {
  // Force the Content Guide to be attach as a tooltip to the first <h2> in
  // the field widgets output.
  $settings_js['attachSelector'] = 'h2:first-of-type';
  $settings_js['cg']['display_type'] = 'tooltip';
}

/**
 * Alter settings used by the controller to get the content guide document.
 *
 * @param array $settings
 *   Content guide settings.
 * @param array $context
 *   Additional information useful when altering the settings.
 */
function hook_cg_controller_widget_settings_alter(array &$settings, array $context): void {
  // Use different document for field "title".
  if ('title' === $context['field']) {
    $settings['document_path'] = drupal_get_path('module', 'mymodule') . '/guide/title.md';
  }
}

/**
 * Alter display options for content guide documents attached to a field.
 *
 * @param array $options
 *   Content guide display options.
 */
function hook_cg_display_options_alter(array &$options): void {
  // Add custom display option.
  $options['system_message'] = t('System message');
}

/**
 * @} End of "addtogroup hooks".
 */
