(function (Drupal, drupalSettings) {
  /**
   * Attach a description to the given element.
   *
   * @param {Node} field
   *   Field to attach the element to.
   * @param {array} fieldSettings
   *   Field settings.
   * @param {array} settings
   *   Drupal JavaScript settings.
   */
  Drupal.ContentGuide.attachDescription = function (
    field,
    fieldSettings,
    settings,
  ) {
    if (field.querySelector('[data-cg-content]') !== null) {
      // Element is already attached to the field.
      return;
    }

    const attachSelector = fieldSettings.attach_selector || '.form-item__label';

    let attachElement = null;
    if (attachSelector === '::self::') {
      // Use field to attach the description.
      attachElement = field;
    } else {
      attachElement = field.querySelector(attachSelector);
    }

    if (attachElement === null) {
      // Use the first child of the field to attach the description.
      attachElement = field.firstElementChild;
    }

    const content_url = Drupal.ContentGuide.buildContentUrl(field, settings);

    const description = document.createElement('div');
    description.setAttribute('data-cg-content', true);
    description.classList.add('content-guide--description');

    fetch(content_url, {
      type: 'get',
      headers: {
        'X-CSRF-Token': fieldSettings._token,
        'X-CG-Identifier': field.dataset.cgIdentifier,
        'X-CG-Document-Path': fieldSettings.document_path,
      },
    })
      .then((response) => response.json())
      .then((data) => renderDescription(data));

    function renderDescription(data) {
      description.innerHTML = data.content || data.error;
      attachElement.appendChild(description);
    }
  };
})(Drupal, drupalSettings);
