<?php

namespace Drupal\cg_field_group\EventSubscriber;

use Drupal\cg\ThirdPartyHelperInterface;
use Drupal\field_group\EventDispatcher\FieldGroupFormatSettingsFormEventInterface;
use Drupal\field_group\EventDispatcher\FieldGroupFormatSettingsSummaryEventInterface;
use Drupal\field_group\FieldGroupEvents;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Content guide event subscriber for field groups.
 */
class FieldGroupEventSubscriber implements EventSubscriberInterface {

  use StringTranslationTrait;

  /**
   * Creates a new FieldGroupEventSubscriber object.
   *
   * @param \Drupal\cg\ThirdPartyHelperInterface $thirdPartyHelper
   *   The third party helper service.
   */
  public function __construct(
    protected ThirdPartyHelperInterface $thirdPartyHelper,
  ) {

  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public static function getSubscribedEvents() {
    return [
      FieldGroupEvents::FIELD_GROUP_FORMAT_SETTINGS_FORM => 'formatterSettingsForm',
      FieldGroupEvents::FIELD_GROUP_FORMAT_SETTINGS_SUMMARY => 'formatterSettingsSummary',
    ];
  }

  /**
   * Alter the formatter settings form of a field_group object.
   *
   * @param \Drupal\field_group\EventDispatcher\FieldGroupFormatSettingsFormEventInterface $event
   *   The event.
   */
  public function formatterSettingsForm(FieldGroupFormatSettingsFormEventInterface $event): void {
    $group = $event->getGroup();
    assert(property_exists($group, 'format_settings'));
    $settings = $group->format_settings['cg'] ?? [];
    $settings_form = $this->thirdPartyHelper->buildForm($settings);

    $form =& $event->getForm();
    if (isset($form['cg'])) {
      return;
    }

    if (count($settings_form) > 0) {
      $form['cg'] = $settings_form;
    }
  }

  /**
   * Alter the formatter settings summary.
   *
   * @param \Drupal\field_group\EventDispatcher\FieldGroupFormatSettingsSummaryEventInterface $event
   *   The event.
   */
  public function formatterSettingsSummary(FieldGroupFormatSettingsSummaryEventInterface $event): void {
    $group = $event->getGroup();
    assert(property_exists($group, 'format_settings'));
    $settings = $group->format_settings['cg'] ?? [];

    $summary =& $event->getSummary();

    $additional_summary = $this->thirdPartyHelper->getSummary($settings);
    if (count($additional_summary) === 0) {
      return;
    }

    $summary = array_merge($summary, $additional_summary);
  }

}
