<?php

namespace Drupal\cg\EventDispatcher;

use Drupal\Component\EventDispatcher\Event;

/**
 * Defines an event to alter the controller widget settings.
 */
class AlterControllerWidgetSettingsEvent extends Event implements AlterControllerWidgetSettingsEventInterface {

  /**
   * Constructs a new AlterControllerWidgetSettingsEvent.
   *
   * @param array $settings
   *   Settings used to display the document.
   * @param string $langcode
   *   The current langcode.
   * @param string $identifier
   *   The internal field identifier.
   */
  public function __construct(
    protected array $settings,
    protected string $langcode,
    protected string $identifier,
  ) {

  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function getIdentifier(): string {
    return $this->identifier;
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function getLangcode(): string {
    return $this->langcode;
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function &getSettings(): array {
    return $this->settings;
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function setSettings(array $settings): void {
    $this->settings = $settings;
  }

}
