<?php

namespace Drupal\cg\EventDispatcher;

/**
 * Interface for AlterControllerWidgetSettingsEvent.
 */
interface AlterControllerWidgetSettingsEventInterface {

  /**
   * Get the field identifier.
   *
   * @return string
   *   The internal field identifier.
   */
  public function getIdentifier(): string;

  /**
   * Get the langcode the event is dispatched for.
   *
   * @return string
   *   Langcode used in event.
   */
  public function getLangcode(): string;

  /**
   * Get the widget settings.
   *
   * @return array
   *   List of settings for the field widget.
   */
  public function &getSettings(): array;

  /**
   * Set the widget settings.
   *
   * @param array $settings
   *   List of settings for the field widget.
   */
  public function setSettings(array $settings): void;

}
