<?php

namespace Drupal\cg\EventDispatcher;

use Drupal\Component\EventDispatcher\Event;

/**
 * Defines an event to alter the display options.
 */
class AlterDisplayOptionsEvent extends Event implements AlterDisplayOptionsEventInterface {

  /**
   * Constructs a new AlterDisplayOptionsEvent.
   *
   * @param array $displayOptions
   *   List of display options.
   */
  public function __construct(
    protected array $displayOptions,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function &getDisplayOptions(): array {
    return $this->displayOptions;
  }

}
