<?php

namespace Drupal\cg\EventDispatcher;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBaseInterface;

/**
 * Defines an event to alter the controller widget settings.
 */
class AlterFieldSettingsEvent extends Event implements AlterFieldSettingsEventInterface {

  /**
   * Constructs a new AlterFieldSettingsEvent.
   *
   * @param array $fieldSettings
   *   Third party widget settings.
   * @param array $elements
   *   Form element render array of the widget.
   * @param \Drupal\Core\Field\WidgetBaseInterface|null $widget
   *   The field widget.
   * @param \Drupal\Core\Field\FieldItemListInterface<\Drupal\Core\Field\FieldItemInterface>|null $items
   *   List of field items.
   * @param array $settingsAdditional
   *   Additional javascript settings.
   */
  public function __construct(
    protected array $fieldSettings,
    protected readonly array $elements,
    protected readonly ?WidgetBaseInterface $widget,
    protected readonly ?FieldItemListInterface $items,
    protected readonly array $settingsAdditional,
  ) {

  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function getAdditionalSettings(): array {
    return $this->settingsAdditional;
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function getElements(): array {
    return $this->elements;
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function &getFieldSettings(): array {
    return $this->fieldSettings;
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function getItems(): ?FieldItemListInterface {
    return $this->items;
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function getWidget(): ?WidgetBaseInterface {
    return $this->widget;
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public function setFieldSettings(array $settings): void {
    $this->fieldSettings = $settings;
  }

}
