<?php

namespace Drupal\cg\EventDispatcher;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBaseInterface;

/**
 * Interface for AlterFieldSettingsEvent.
 */
interface AlterFieldSettingsEventInterface {

  /**
   * Get the field settings.
   *
   * @return array
   *   List of javascript settings for the field widget.
   */
  public function &getFieldSettings(): array;

  /**
   * Set the field settings.
   *
   * @param array $settings
   *   List of javascript settings for the field widget.
   */
  public function setFieldSettings(array $settings): void;

  /**
   * Get the widget form elements.
   *
   * @return array
   *   Render array of widget form elements.
   */
  public function getElements(): array;

  /**
   * Get the widget of the field.
   *
   * @return \Drupal\Core\Field\WidgetBaseInterface|null
   *   The field widget.
   */
  public function getWidget(): ?WidgetBaseInterface;

  /**
   * Get the current list of field items.
   *
   * @return \Drupal\Core\Field\FieldItemListInterface<\Drupal\Core\Field\FieldItemInterface>|null
   *   List of field items.
   */
  public function getItems(): ?FieldItemListInterface;

  /**
   * Get list of additional javascript settings for this field.
   *
   * @return array<string, string>
   *   List of additional javascript settings.
   */
  public function getAdditionalSettings(): array;

}
